<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loan Collection Entry</title>
    <!-- Bootstrap CSS for responsiveness -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            margin-top: 50px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        label {
            font-weight: bold;
        }
        input[readonly] {
            background-color: #e9ecef;
        }
        input[type="submit"] {
            background-color: #28a745;
            color: white;
            border: none;
        }
        input[type="submit"]:hover {
            background-color: #218838;
        }
        .btn-main {
            margin-bottom: 20px;
        }
    </style>

    <!-- jQuery for handling AJAX and input formatting -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            // Trigger the AJAX request when Member No is entered
            $('#memberNo').on('blur', function() {
                var memberNo = $(this).val();

                if (memberNo !== '') {
                    // AJAX request to fetch member name and loan info
                    $.ajax({
                        url: 'fetch_member_loan.php',
                        type: 'POST',
                        data: { memberNo: memberNo },
                        success: function(response) {
                            var data = JSON.parse(response);
                            
                            if (data.success) {
                                $('#memberName').val(data.memberName);
                                $('#loanNo').val(data.loanNo);
                                
                                // Format the loan amount with commas
                                var formattedLoanAmount = parseFloat(data.LoanBalance).toLocaleString('en-US', {
                                    minimumFractionDigits: 0,
                                    maximumFractionDigits: 0
                                });
                                $('#loanAmount').val(formattedLoanAmount);
                            } else {
                                alert('Member not found or no active loans.');
                                $('#memberName').val('');
                                $('#loanNo').val('');
                                $('#loanAmount').val('');
                            }
                        }
                    });
                }
            });

            // Format the Amount Paid field with comma as delimiter
            $('#amountPaid').on('input', function() {
                var input = $(this).val().replace(/,/g, ''); // Remove commas for calculation
                if (!isNaN(input) && input.length > 0) {
                    var formatted = parseFloat(input).toLocaleString('en-US', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    });
                    $(this).val(formatted);
                }
            });

            // Remove formatting before form submission
            $('form').on('submit', function() {
                // Remove commas from the Loan Amount and Amount Paid before submission
                var rawLoanAmount = $('#loanAmount').val().replace(/,/g, ''); // Remove commas from loanAmount
                $('#loanAmount').val(rawLoanAmount);

                var rawAmountPaid = $('#amountPaid').val().replace(/,/g, ''); // Remove commas from amountPaid
                $('#amountPaid').val(rawAmountPaid);
            });
        });
    </script>
</head>
<body>

<div class="container">
    <!-- "Back to Main Page" Button -->
    <a href="index.html" class="btn btn-primary btn-main">Back to Main Page</a> <!-- Update href with the actual URL -->

    <h1 class="text-center mb-4">Enter Loan Collection</h1>
    <form action="process_collection.php" method="POST">
        <div class="mb-3">
            <label for="memberNo">Member No:</label>
            <input type="number" class="form-control" id="memberNo" name="memberNo" required>
        </div>

        <div class="mb-3">
            <label for="memberName">Member Name:</label>
            <input type="text" class="form-control" id="memberName" name="memberName" readonly>
        </div>
		
		<div class="mb-3">
            <label for="amountPaid">Amount Paid:</label>
            <input type="text" class="form-control" id="amountPaid" name="amountPaid" required>
        </div>

        <div class="mb-3">
            <label for="officerID">Officer ID:</label>
            <input type="number" class="form-control" id="officerID" name="officerID" required>
        </div>
		
		<div class="mb-3">
            <label for="loanAmount">Current Loan Amount:</label>
            <input type="text" class="form-control" id="loanAmount" name="loanAmount" readonly>
        </div>
		
        <div class="mb-3">
            <label for="loanNo">Loan No:</label>
            <input type="number" class="form-control" id="loanNo" name="loanNo" readonly>
        </div>







        <input type="submit" class="btn btn-success w-100" value="Submit Collection">
    </form>
</div>

<!-- Bootstrap JS for responsive behavior -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
