<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: index.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    
    <meta name="robots" content="noindex, nofollow">
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register New Member</title>
    <!-- Bootstrap CSS for responsive design -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            margin-top: 50px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
        }
        .btn-primary, .btn-secondary {
            width: 100%;
        }
        .btn-secondary {
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="container">

 <!-- Button to redirect to the main page -->
    <a href="home.php" class="btn btn-secondary">Go to Main Page</a> - <br><a href="view_members.php" class="btn btn-primary">View Members</a>
    <h2>Register New Member</h2>
    <form action="register_member.php" method="POST">
        <div class="mb-3">
            <label for="memberName" class="form-label">Full Name</label>
            <input type="text" class="form-control" id="memberName" name="memberName" required>
        </div>
        <div class="mb-3">
            <label for="memberPhoneNo" class="form-label">Phone Number</label>
            <input type="tel" class="form-control" id="memberPhoneNo" name="memberPhoneNo" pattern="^\d{9,15}$" required>
        </div>
        <div class="mb-3">
            <label for="memberAddress" class="form-label">Address</label>
            <input type="text" class="form-control" id="memberAddress" name="memberAddress" required>
        </div>
        <div class="mb-3">
            <label for="registrationDate" class="form-label">Registration Date</label>
            <input type="date" class="form-control" id="registrationDate" name="registrationDate" required>
        </div>
        <button type="submit" class="btn btn-primary">Register Member</button>
    </form>

   
</div>

<!-- Bootstrap JS for responsiveness -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
