<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: index.php");
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    
    <meta name="robots" content="noindex">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loan Collection Entry</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            margin-top: 50px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        label {
            font-weight: bold;
        }
        input[readonly] {
            background-color: #e9ecef;
        }
        input[type="submit"] {
            background-color: #28a745;
            color: white;
            border: none;
        }
        input[type="submit"]:hover {
            background-color: #218838;
        }
        .btn-main {
            margin-bottom: 20px;
        }
        .sms-balance {
            font-size: 1.2em;
            font-weight: bold;
            color: #333;
            margin-bottom: 20px;
            text-align: right;
        }
    </style>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Fetch and display SMS balance on page load
            $.ajax({
                url: 'fetch_sms_balance.php',
                type: 'GET',
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        $('#smsBalance').text('SMS Balance: ' + data.balance);
                    } else {
                        $('#smsBalance').text('Unable to fetch SMS balance.');
                    }
                }
            });

            $('#memberNo').on('blur', function() {
                var memberNo = $(this).val();
                if (memberNo !== '') {
                    $.ajax({
                        url: 'fetch_member_loan.php',
                        type: 'POST',
                        data: { memberNo: memberNo },
                        success: function(response) {
                            var data = JSON.parse(response);
                            if (data.success) {
                                $('#memberName').val(data.memberName);
                                $('#loanNo').val(data.loanNo);
                                var formattedLoanAmount = parseFloat(data.LoanBalance).toLocaleString('en-US', {
                                    minimumFractionDigits: 0,
                                    maximumFractionDigits: 0
                                });
                                $('#loanAmount').val(formattedLoanAmount);
                            } else {
                                alert('Member not found or no active loans.');
                                $('#memberName').val('');
                                $('#loanNo').val('');
                                $('#loanAmount').val('');
                            }
                        }
                    });
                }
            });

            $('#amountPaid').on('input', function() {
                var input = $(this).val().replace(/,/g, '');
                if (!isNaN(input) && input.length > 0) {
                    var formatted = parseFloat(input).toLocaleString('en-US', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    });
                    $(this).val(formatted);
                }
            });

            $('form').on('submit', function() {
                var rawLoanAmount = $('#loanAmount').val().replace(/,/g, '');
                $('#loanAmount').val(rawLoanAmount);
                var rawAmountPaid = $('#amountPaid').val().replace(/,/g, '');
                $('#amountPaid').val(rawAmountPaid);
            });
        });
    </script>
</head>
<body>

<div class="container">
    <a href="home.php" class="btn btn-primary btn-main">Back to Main Page</a>
    <h1 class="text-center mb-4">Enter Loan Collection</h1>
    <div class="sms-balance" id="smsBalance">Loading SMS balance...</div>

    <form action="process_collection.php" method="POST">
        <div class="mb-3">
            <label for="memberNo">Member No:</label>
            <input type="number" class="form-control" id="memberNo" name="memberNo" required>
        </div>
        <div class="mb-3">
            <label for="memberName">Member Name:</label>
            <input type="text" class="form-control" id="memberName" name="memberName" readonly>
        </div>
        <div class="mb-3">
            <label for="amountPaid">Amount Paid:</label>
            <input type="text" class="form-control" id="amountPaid" name="amountPaid" required>
        </div>
        <div class="mb-3">
            <label for="officerID">Officer ID:</label>
            <input type="number" class="form-control" id="officerID" name="officerID" required>
        </div>
        <div class="mb-3">
            <label for="loanAmount">Current Loan Amount:</label>
            <input type="text" class="form-control" id="loanAmount" name="loanAmount" readonly>
        </div>
        <div class="mb-3">
            <label for="loanNo">Loan No:</label>
            <input type="number" class="form-control" id="loanNo" name="loanNo" readonly>
        </div>
        <input type="submit" class="btn btn-success w-100" value="Submit Collection">
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
