<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Collection Records</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            margin-top: 50px;
        }
        h1 {
            text-align: center;
            margin-bottom: 30px;
        }
        table.dataTable {
            width: 100%;
            margin: auto;
        }
    </style>

    <script>
$(document).ready(function() {
    $('#collectionTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "fetch_collection_data1.php",  // Your server-side script
            "type": "POST"
        },
        "columns": [
            { "data": "memberNo" },
            { "data": "memberName" },
            { "data": "memberPhoneNo" },
            {
                "data": "amount",  // Loan Balance
                "render": function(data, type, row) {
                    return formatCurrency(data);  // Format as currency
                }
            },
            {
                "data": "amountPaid",  // Amount Paid
                "render": function(data, type, row) {
                    return formatCurrency(data);  // Format as currency
                }
            },
            { "data": "receiptNo" },
            { "data": "paidDate" },
            { "data": "officerName" }
        ],
        "order": [[6, "desc"]]
    });
	

    // Function to format numbers as currency
    function formatCurrency(amount) {
        return new Intl.NumberFormat('en-US', {
          //  style: 'currency',
          //  currency: 'Tzs',
			minimumFractionDigits: 0,  // No decimal places
            maximumFractionDigits: 0   // No decimal places
        }).format(amount);
    }
	
	

	
});
    </script>
</head>
<body>

<div class="container">
    <h1>Collection Records</h1>
    <table id="collectionTable" class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>MemberNo</th>
                <th>Name</th>
                <th>PhoneNo</th>
				 <th>LoanBalance</th>
				 <th>AmountPaid</th>
				 <th>receiptNo</th>
				<th>PaidDate</th>
                 <th>OfficerName</th>
            </tr>
        </thead>
    </table>
</div>

</body>
</html>
