<?php
// Include the database connection details
include("include/connection.php");

$conn = new mysqli($host, $user, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$message = "";  // Variable to store the success or error message

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Capture form data
    $memberName = $_POST['memberName'];
    $memberPhoneNo = $_POST['memberPhoneNo'];
    $memberAddress = $_POST['memberAddress'];
    $registrationDate = $_POST['registrationDate'];

    // Insert data into the member table
    $sql = "INSERT INTO member (memberName, memberPhoneNo, memberAddress, registrationDate)
            VALUES ('$memberName', '$memberPhoneNo', '$memberAddress', '$registrationDate')";

    if ($conn->query($sql) === TRUE) {
        $message = "New member registered successfully";
    } else {
        $message = "Error: " . $sql . "<br>" . $conn->error;
    }

    // Close connection
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register New Member</title>
    <!-- Bootstrap CSS for responsive design -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            margin-top: 50px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
        }
        .btn-primary, .btn-secondary {
            width: 100%;
        }
        .btn-secondary {
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Register New Member</h2>

    <!-- Display success or error message -->
    <?php if ($message): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
        <div class="mb-3">
            <label for="memberName" class="form-label">Full Name</label>
            <input type="text" class="form-control" id="memberName" name="memberName" required>
        </div>
        <div class="mb-3">
            <label for="memberPhoneNo" class="form-label">Phone Number</label>
            <input type="tel" class="form-control" id="memberPhoneNo" name="memberPhoneNo" pattern="^\d{9,15}$" required>
        </div>
        <div class="mb-3">
            <label for="memberAddress" class="form-label">Address</label>
            <input type="text" class="form-control" id="memberAddress" name="memberAddress" required>
        </div>
        <div class="mb-3">
            <label for="registrationDate" class="form-label">Registration Date</label>
            <input type="date" class="form-control" id="registrationDate" name="registrationDate" required>
        </div>
        <button type="submit" class="btn btn-primary">Register Member</button>
    </form>

    <!-- Button to redirect to the main page -->
    <a href="index.html" class="btn btn-secondary">Go to Main Page</a>
</div>

<!-- Bootstrap JS for responsiveness and alerts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
